/* This demo program is loosely based on the following version of
   Rod's Color Pattern in C by Dr. John B. Matthews:

   http://home.roadrunner.com/~jbmatthews/apple2.html#rp1c

   Which in turn is based on Rod's Color Pattern, written in Basic
   by Randy Wigginton, which originally appeared on page 55 of the Red Book
   distributed by Apple Computer, Inc. circa 1978. It was described as
   "a simple but eloquent program. It generates a continuous flow of colored
   mosaic-like patterns in a 40 high by 40 wide block matrix.
   Many of the patterns generated by this program are pleasing to the eye
   and will dazzle the mind for minutes at a time."

   At any rate this particular version is for the hires display and isn't
   quite as spectacular as the lores version but is included anyway
   by way of a graphics demo.

   Bill Buckels
   December 2009

 */

#include <g3.h>

hrod ()
{

    int i, j, k, w, fmi, fmk, color, c=0;

	for (w = 3; w < 51; w++) {
		for (i = 1; i < 20; i++) {
			for (j = 0; j < 20; j++) {
				k = i + j;
				color = (j * 3) / (i + 3) + i * w / 12;
				fmi = 40 - i;
				fmk = 40 - k;

				color = (color/2)&7;

				hibox( i-1, k*4, i, k*4+3, color);
				hibox( k-1, i*4, k, i*4+3, color);

				hibox( fmi-1, fmk*4, fmi, fmk*4 + 3,color);
				hibox( fmk-1, fmi*4, fmk, fmi*4 + 3,color);

				hibox( k-1, fmi*4, k, fmi*4+3,color);
				hibox( fmi-1, k*4, fmi, k*4+3,color);

				hibox( i-1, fmk*4, i, fmk*4+3,color);
				hibox( fmk-1, i*4, fmk, i*4+3,color);
				if ((c = kbhit()) > 0) {
					clearkey();
					return c-128;

				}
			}
		}
	}

	if ((c = kbhit()) > 0) {
		clearkey();
		c-=128;
	}


	return c;

}





main()
{


    setcrtmode(GRAFMODE);
    clearkey();
    for (;;) {
		hibox(0,0,39,191,0);
		if (hrod()==27)break;

    }
	setcrtmode(TEXTMODE);
	scr_apple();
	reboot();

}




